package ru.yandex.tours.util.trie;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;

/**
* @author aherman
*/
public class FastCharMapBuilder implements AbstractFastCharMap {
    private final ArrayList<FMBEntry> entries = new ArrayList<FMBEntry>();

    @Override
    public int get(char ch, int defaultValue) {
        FMBEntry entry = findEntry(ch);
        if (entry != null) {
            return entry.value;
        }
        return defaultValue;
    }

    private FMBEntry findEntry(char ch) {
        for (FMBEntry entry : entries) {
            if (entry.key == ch) {
                return entry;
            }
        }
        return null;
    }

    @Override
    public void put(char ch, int i) {
        FMBEntry entry = findEntry(ch);
        if (entry != null) {
            entry.value = i;
            return;
        }
        entries.add(new FMBEntry(ch, i));
    }

    public FMBEntry getFirst() {
        return entries.get(0);
    }

    @Override
    public int size() {
        return entries.size();
    }

    @Override
    public boolean isEmpty() {
        return entries.isEmpty();
    }

    public FastCharMap build() {
        Collections.sort(entries);
        char[] keys = new char[entries.size()];
        int[] values = new int[entries.size()];
        for (int i = 0; i < entries.size(); i++) {
            FMBEntry entry = entries.get(i);
            keys[i] = entry.key;
            values[i] = entry.value;
        }
        return new FastCharMap(keys, values);

    }

    @Override
    public Iterator<Character> getKeys() {
        return new Iterator<Character>() {
            private Iterator<FMBEntry> internal = entries.iterator();
            @Override
            public boolean hasNext() {
                return internal.hasNext();
            }

            @Override
            public Character next() {
                return internal.next().key;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static class FMBEntry implements Comparable<FMBEntry> {
        public final char key;
        public int value;

        public FMBEntry(char key, int value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public int compareTo(FMBEntry o) {
            if (key < o.key) {
                return -1;
            }
            return key == o.key ? 0 : 1;
        }
    }
}
