package ru.yandex.tours.util.trie;

import java.util.Iterator;

/**
 * @author aherman
 */
public class TrieNodeBuilder {
    private FastCharMapBuilder edges;
    private final int id;
    private boolean terminal;
    private int bord = TrieNode.UNDEFINED_ID;

    public TrieNodeBuilder(int id) {
        this.id = id;
        this.edges = new FastCharMapBuilder();
    }

    public int getId() {
        return id;
    }

    TrieNode build() {
//        if (edges.size() == 0) {
//            return new TrieNode.NoChildNode(id, terminal, bord);
//        } else if (edges.size() == 1) {
//            FastCharMapBuilder.FMBEntry firstEdge = edges.getFirst();
//            return new TrieNode.SingleChildNode(id, terminal, bord, firstEdge.key, firstEdge.value);
//        }
        return new TrieNode.ManyChildNode(id, terminal, bord, edges.build());
    }

    public boolean isTerminal() {
        return terminal;
    }

    public int getBord() {
        return bord;
    }

    public int getSon(char ch) {
        return edges.get(ch, TrieNode.UNDEFINED_ID);
    }

    public void addSon(char ch, int nodeId) {
        edges.put(ch, nodeId);
    }

    public void setTerminal(boolean terminal) {
        this.terminal = terminal;
    }

    public void setBord(int bord) {
        this.bord = bord;
    }

    public Iterator<Character> getEdges() {
        return edges.getKeys();
    }

    public int getEdgesNumber() {
        return edges.size();
    }

    public String toString() {
        return "N{" + id + "; t=" + terminal + "; b=" + bord + "}";
    }


}
