package ru.yandex.tours.util.xml

import java.io.{ByteArrayInputStream, FileInputStream, File, InputStream}

import ru.yandex.tours.model.Languages
import ru.yandex.tours.model.Languages.Lang
import ru.yandex.tours.util.xml.XmlParser.Tag

import scala.util.Try

trait XmlParser {
  def processTag(name: String, handler: PartialFunction[String, Unit]): Unit

  def getAttributes: Iterable[(String, String)]

  def getText: String

  def getOptAttribute(name: String): Option[String] = getAttributes.collectFirst {
    case (x, value) if x == name => value
  }

  def getAttribute(name: String) = getOptAttribute(name).get

  def getLangText: (Lang, String) = {
    getOptAttribute("lang").map { lang =>
      Try(Languages.withName(lang)).getOrElse(Languages.other)
    }.getOrElse(Languages.other) -> getText
  }

  def nextTag: Option[Tag]
}

object XmlParser {
  case class Tag(name: String, isStart: Boolean)

  def create(is: InputStream): XmlParser = new XmlParserImpl(is)

  def create(file: File): XmlParser = new XmlParserImpl(new FileInputStream(file))

  def create(string: String): XmlParser = new XmlParserImpl(new ByteArrayInputStream(string.getBytes))
}
