package ru.yandex.tours.util.xml

import java.io.InputStream
import javax.xml.stream.XMLInputFactory

import ru.yandex.tours.util.xml.XmlParser.Tag

import scala.util.Try

class XmlParserImpl(is: InputStream) extends XmlParser {

  private val factory = XMLInputFactory.newInstance
  private val parser = factory.createXMLStreamReader(is)

  override def processTag(name: String, handler: PartialFunction[String, Unit]): Unit = {
    while (!parser.isStartElement || !parser.getLocalName.equalsIgnoreCase(name)) {
      nextTag(s"No tag '$name' found")
    }
    while (!parser.isEndElement || !parser.getLocalName.equalsIgnoreCase(name)) {
      if (parser.isStartElement) {
        val childName = parser.getLocalName.toLowerCase
        if (handler.isDefinedAt(childName)) handler(childName)
      }
      nextTag(s"No matching closing tag for $name")
    }
  }

  override def getAttributes: Iterable[(String, String)] = {
    (0 until parser.getAttributeCount).map { i =>
      parser.getAttributeLocalName(i) -> parser.getAttributeValue(i)
    }
  }

  override def getText: String = {
    parser.getElementText
  }

  private def nextTag(message: String) = {
    parser.next
    while (parser.hasNext && !(parser.isEndElement || parser.isStartElement)) {
      parser.next()
    }
    if (!parser.hasNext) sys.error(message)
  }

  override def nextTag = {
    Try(nextTag("")).map { _ =>
      Tag(parser.getLocalName.toLowerCase, parser.isStartElement)
    }.toOption
  }
}
