package ru.yandex.tours.util.zoo

import org.apache.commons.codec.Charsets
import ru.yandex.vertis.curator.recipes.map.ValueSerializer

import scala.util.Try

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 31.03.15
 */
object BooleanSerializer extends ValueSerializer[Boolean] {
  override def serialize(elem: Boolean): Array[Byte] = elem.toString.getBytes(Charsets.UTF_8)

  override def deserialize(data: Array[Byte]): Try[Boolean] = Try(new String(data, Charsets.UTF_8).toBoolean)
}
