package ru.yandex.tours.util.zoo

import org.apache.commons.codec.Charsets
import org.joda.time.DateTime
import org.joda.time.format.ISODateTimeFormat
import ru.yandex.vertis.curator.recipes.map.ValueSerializer

import scala.util.Try

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 13.03.15
 */
object DateTimeSerializer extends ValueSerializer[DateTime] {
  private val formatter = ISODateTimeFormat.basicDateTime()

  override def serialize(date: DateTime): Array[Byte] =
    date.toString(formatter).getBytes(Charsets.UTF_8)

  override def deserialize(data: Array[Byte]): Try[DateTime] =
    Try(formatter.parseDateTime(new String(data, Charsets.UTF_8)))
}
