package ru.yandex.tours.util.zoo

import org.apache.commons.codec.Charsets
import ru.yandex.vertis.curator.recipes.map.ValueSerializer

import scala.util.Try

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 03.03.15
 */
object DoubleSerializer extends ValueSerializer[Double] {
  override def serialize(elem: Double): Array[Byte] = elem.toString.getBytes(Charsets.UTF_8)

  override def deserialize(data: Array[Byte]): Try[Double] = Try(new String(data, Charsets.UTF_8).toDouble)
}
