package ru.yandex.tours.util.zoo

import org.apache.commons.codec.Charsets
import ru.yandex.vertis.curator.recipes.map.ValueSerializer

import scala.util.Try

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 13.03.15
 */
object IntSerializer extends ValueSerializer[Int] {
  override def serialize(elem: Int): Array[Byte] = elem.toString.getBytes(Charsets.UTF_8)

  override def deserialize(data: Array[Byte]): Try[Int] = Try(new String(data, Charsets.UTF_8).toInt)
}
