package ru.yandex.tours.util.zoo

import org.apache.commons.codec.Charsets
import ru.yandex.vertis.curator.recipes.map.ValueSerializer
import ru.yandex.tours.util.parsing.Tabbed

import scala.util.Try

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 20.05.15
 */
object StringSetSerializer extends ValueSerializer[Set[String]] {
  override def serialize(elem: Set[String]): Array[Byte] = {
    elem.mkString("\t").getBytes(Charsets.UTF_8)
  }

  override def deserialize(data: Array[Byte]): Try[Set[String]] = Try {
    new String(data, Charsets.UTF_8) match {
      case Tabbed(elems @_*) => elems.toSet
      case _ => Set.empty
    }
  }
}
