package ru.yandex.tours.yocto

import java.io.File

import com.yandex.yoctodb.DatabaseFormat
import com.yandex.yoctodb.immutable.IndexedDatabase
import com.yandex.yoctodb.util.buf.Buffer
import com.yandex.yoctodb.util.mutable.impl.AllocatingArrayBitSetPool
import ru.yandex.extdata.common.meta.DataType
import ru.yandex.tours.extdata.FileBaseHolder
import ru.yandex.tours.util.Logging

case class DatabaseWrapper(db: IndexedDatabase)

class YoctoShardHolder(dir: File, dataType: DataType, useGz: Boolean)
  extends FileBaseHolder[DatabaseWrapper](dir, dataType, useGz) with Logging {

  override def parseFile(file: File): DatabaseWrapper = {
    val buffer = Buffer.mmap(file, false)
    val db = DatabaseFormat.getCurrent.getDatabaseReader.from(buffer, AllocatingArrayBitSetPool.INSTANCE, false)
    log.info(s"Loaded ${db.getDocumentCount} documents from $file, dataType = $dataType")
    DatabaseWrapper(db)
  }

}
