#!/bin/sh

. ./component.sh

JAVA_HOME=/usr/local/java8
PATH="$JAVA_HOME/bin:$PATH"
LANG=ru_RU.UTF8
PID_FILE=$DAEMON.pid
LOG_DIR=logs
HPROF_DIR=hprof/$DAEMON
GC_LOG=$DAEMON-gc.log
LIB_PATH=lib
mkdir -p logs

CLASSPATH=`find $LIB_PATH -name '*.jar' -printf '%p:'`$CLASSPATH

export PATH LANG JAVA_HOME CLASSPATH
#-agentpath:./libyjpagent.so \

java -classpath $CLASSPATH  \
     -Dfile.encoding=UTF8 \
     -Doracle.net.tns_admin=/etc/oracle \
     -showversion -server -Xverify:none \
     -Xmx6g -Xms6g \
     -XX:+UseParallelGC \
     -XX:+UseParallelOldGC \
     -XX:+UseTLAB \
     -XX:+HeapDumpOnOutOfMemoryError \
     -XX:HeapDumpPath=$HPROF_DIR \
     -XX:OnOutOfMemoryError="echo on oom killing process %p; kill -9 %p" \
     -Xloggc:logs/$GC_LOG \
     -XX:+PrintCommandLineFlags \
     -XX:+PrintGCApplicationStoppedTime \
     -XX:+PrintGCDetails \
     -Djava.net.preferIPv6Addresses=true \
     -XX:+PrintGCDateStamps \
     -XX:+PrintGCCause \
     -XX:+PrintPromotionFailure \
     -XX:+PrintGCApplicationStoppedTime \
     -Dhost.name=`/bin/hostname --fqdn` \
     -Dsun.net.client.defaultConnectTimeout=10000 \
     -Dsun.net.client.defaultReadTimeout=10000 \
     -Dsun.net.inetaddr.ttl=86400 -Dhttp.keepAlive=false \
     -Dlogging.path=$LOG_DIR \
     ru.yandex.tours.IndexerMain >> $LOG_DIR/$DAEMON.log.shell 2>&1 &

echo $! > $PID_FILE