package ru.yandex.tours.avatars

import ru.yandex.tours.app._
import ru.yandex.tours.avatars.yt.Avatar

trait AvatarSupport {
  app: Application with HttpSupport with AkkaSupport with YtSupport =>
  lazy val avatarClient: AvatarClient = {
    val writeUrl = app.config.getString("tours.avatars.write.url")
    val readUrl = app.config.getString("tours.avatars.read.url")
    val httpAvatarClient = new HttpAvatarClient(httpClient, writeUrl, readUrl, "tours")(akkaSystem.dispatcher)
    val queuedClient = new QueuedAvatarClient(httpAvatarClient, 1000)(akkaSystem.dispatcher, akkaSystem)
    lazy val ytDao = new YtAvatarDao(createYtDao(classOf[Avatar], ytSettings.primaryCluster))(akkaSystem.dispatcher)
    new CachingAvatarClient(ytDao, queuedClient)(akkaSystem.dispatcher)
  }
}
