package ru.yandex.tours.avatars

import akka.actor.ActorSystem
import ru.yandex.tours.model.Image
import ru.yandex.tours.model.image.ImageProviders.ImageProvider
import ru.yandex.tours.util.concurrent.AsyncWorkQueue
import spray.http.StatusCode

import scala.concurrent.{ExecutionContext, Future}

class QueuedAvatarClient(client: AvatarClient, queueSize: Int)
                        (implicit ec: ExecutionContext, as: ActorSystem) extends AvatarClient {

  private val queue = new AsyncWorkQueue(queueSize)

  override def put(url: String, provider: ImageProvider): Future[Image] =
    queue.submit(client.put(url, provider))

  override def putRaw(url: String, imageName: String, provider: ImageProvider): Future[(StatusCode, String)] =
    queue.submit(client.putRaw(url, imageName, provider))

  override def recover(image: Image): Future[Image] =
    queue.submit(client.recover(image))
}
