package ru.yandex.tours.avatars.yt;

import ru.yandex.travel.yt.mappings.YtColumn;
import ru.yandex.travel.yt.mappings.YtTable;
import ru.yandex.yt.ytclient.tables.ColumnValueType;

@YtTable(tableName = "avatars")
public class Avatar {
    @YtColumn()
    private String Url;

    @YtColumn()
    private int Group;

    @YtColumn()
    private int Provider;

    @YtColumn()
    private String Host;

    @YtColumn()
    private String Name;

    @YtColumn()
    private Integer Width;

    @YtColumn()
    private Integer Height;

    @YtColumn()
    private String pHash;

    @YtColumn()
    private String NNF;

    public Avatar(String url, Integer group, Integer provider, String host, String name, int width, int height, String pHash, String NNF) {
        Url = url;
        Group = group;
        Provider = provider;
        Host = host;
        Name = name;
        Width = width;
        Height = height;
        this.pHash = pHash;
        this.NNF = NNF;
    }

    public Avatar() {
    }

    public String getUrl() {
        return Url;
    }

    public int getGroup() {
        return Group;
    }

    public int getProvider() {
        return Provider;
    }

    public String getHost() {
        return Host;
    }

    public String getName() {
        return Name;
    }

    public Integer getWidth() {
        return Width;
    }

    public Integer getHeight() {
        return Height;
    }

    public String getpHash() {
        return pHash;
    }

    public String getNNF() {
        return NNF;
    }

    public void setUrl(String url) {
        Url = url;
    }

    public void setGroup(int group) {
        Group = group;
    }

    public void setProvider(int provider) {
        Provider = provider;
    }

    public void setHost(String host) {
        Host = host;
    }

    public void setName(String name) {
        Name = name;
    }

    public void setWidth(Integer width) {
        Width = width;
    }

    public void setHeight(Integer height) {
        Height = height;
    }

    public void setpHash(String pHash) {
        this.pHash = pHash;
    }

    public void setNNF(String NNF) {
        this.NNF = NNF;
    }
}
