package ru.yandex.tours.extdata

import ru.yandex.extdata.common.service.ExtDataService
import ru.yandex.tours.app.Application
import ru.yandex.tours.extdataloader.ExtDataLoaderServices

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 28.04.15
 */
trait EmbeddedExtDataSupport extends ExtDataSupport { app: Application with ExtDataLoaderServices =>
  override lazy val extDataService: ExtDataService = {
    new ru.yandex.extdata.loader.local.LocalExtDataService(metaDataStorageService, extDataStorageService)
  }
  override lazy val extDataUpdateChecker: ExtDataUpdateChecker = {
    val checker = new EmbeddedExtDataUpdateChecker(metaDataStorageService)
    onStart {
      app.dataPersistenceManager.setBroadCastService(checker)
    }
    checker
  }
}
