package ru.yandex.tours.extdata

import ru.yandex.extdata.common.meta.{DataType, MetaDataInstance}
import ru.yandex.extdata.common.notification.{BroadcastService, ExtDataMessage}
import ru.yandex.extdata.loader.storage.MetaDataStorageService

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 28.04.15
 */
class EmbeddedExtDataUpdateChecker(metaDataStorageService: MetaDataStorageService)
  extends AbstractExtDataUpdateChecker with BroadcastService {

  override protected def getLastVersion(dataType: DataType): Int = {
    val formatVersion = dataType.getCurrentFormatVersion
    val meta = metaDataStorageService.getMetaData(dataType.getName)
    if ((meta ne null) && meta.isDataLoaded(formatVersion)) {
      val instance = meta.getLastDataInstance(formatVersion)
      instance.getVersion
    } else {
      sys.error(s"Data not loaded for $dataType")
    }
  }

  override def publishData(message: ExtDataMessage): Unit = {
    val dataType = message.getDataType
    updated(Map(dataType -> message.getVersion))
  }
}
