package ru.yandex.tours.extdataloader

import java.io._

import org.apache.commons.io.IOUtils
import ru.yandex.extdata.loader.storage.DataStorageService
import ru.yandex.tours.util.file._

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 25.02.15
 */
class FSDataStorageService(dir: File) extends DataStorageService {
  require(dir.exists() || dir.mkdirs(), "Cannot create directory " + dir)

  override def saveData(id: String, bytes: Array[Byte]): Unit = {
    val file = dir / id
    val tmpFile = dir / (id + ".tmp")

    val os = new FileOutputStream(tmpFile)
    try IOUtils.write(bytes, os)
    finally IOUtils.closeQuietly(os)

    file.delete()
    tmpFile.renameTo(file)
  }

  override def drainDataTo(id: String, output: OutputStream): Unit = {
    val is = readData(id)
    try IOUtils.copy(is, output)
    finally IOUtils.closeQuietly(is)
  }

  override def readData(id: String): InputStream = new FileInputStream(dir / id)

  override def removeFile(id: String): Unit = (dir / id).delete()
}
