package ru.yandex.tours.extdataloader

import java.io.InputStream

import ru.yandex.extdata.loader.loaders.{SimpleDataLoader, ThreadedHttpClient}
import ru.yandex.extdata.loader.specs.HttpDataLoadSpec
import ru.yandex.tours.util.IO

class HttpDataWithProcessingLoader(processor: InputStream => InputStream) extends SimpleDataLoader[HttpDataLoadSpec]{
  private var httpLoader: ThreadedHttpClient = _

  def setHttpLoader(httpLoader: ThreadedHttpClient): Unit = {
    this.httpLoader = httpLoader
  }

  override def loadData(params: HttpDataLoadSpec): InputStream = {
    IO.using(httpLoader.download(params.getUrl)) { is => processor(is) }
  }
}
