package ru.yandex.tours.extdataloader.verba

import java.io.InputStream
import java.util.zip.GZIPInputStream

import ru.yandex.extdata.common.meta.DataType
import ru.yandex.tours.extdata.{DataDef, DataTypes}
import ru.yandex.verba2.model.Dictionary
import ru.yandex.verba2.parse.SaxVerbaParser

import scala.collection.JavaConversions._

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 29.04.15
 */
class Verba(dictionariesList: Seq[Dictionary]) {
  def this() = this(Seq.empty)
  def dictionaries = dictionariesList
  def dictionary(code: String) = dictionariesList.find(_.getCode == code).getOrElse(sys.error(s"Dictionary $code not found"))
}

object Verba extends DataDef[Verba] {
  override def dataType: DataType = DataTypes.verba

  override def parse(is: InputStream): Verba = {
    val service = new SaxVerbaParser().parseXml(new GZIPInputStream(is))
    new Verba(service.getDictionaries)
      .ensuring(_.dictionaries.nonEmpty, "Verba is empty")
  }
}