package ru.yandex.tours.extdataloader.verba

import java.util.Collections

import ru.yandex.verba2.model.Term
import ru.yandex.verba2.model.attribute._

import scala.collection.JavaConversions._
import scala.reflect._


/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 29.04.15
 */
trait VerbaDSL {
  implicit class RichTerm(term: Term) {
    def attr[T <: Attribute : ClassTag](name: String) = {
      term.getAttribute(name) match {
        case a if classTag[T].runtimeClass.isInstance(a) => a.asInstanceOf[T]
        case a => sys.error(s"Expected [${classTag[T].runtimeClass}] got [${a.getClass}] in attribute [$name]")
      }
    }
    def attrOpt[T <: Attribute : ClassTag](name: String) = {
      term.getAttribute(name) match {
        case a if classTag[T].runtimeClass.isInstance(a) => Some(a.asInstanceOf[T])
        case a => None
      }
    }

    def stringValue(name: String) = attr[StringAttribute](name).getValues.head
    def booleanOptValue(name: String) = attrOpt[BooleanAttribute](name).map(_.getValue)
    def intValue(name: String) = attr[StringAttribute](name).getValues.head.toInt
    def doubleValue(name: String) = doubleOptValue(name).get
    def doubleOptValue(name: String) = attrOpt[StringAttribute](name).flatMap(_.getValues.headOption.map(_.toDouble))
    def longOptValue(name: String) = attrOpt[StringAttribute](name).flatMap(_.getValues.headOption.map(_.toLong))
    def complexValue(name: String) = attr[ComplexAttribute](name).getComplexEntities
  }

  implicit class RichComplexContainer(cc: ComplexContainer) {
    def attr[T <: Attribute : ClassTag](name: String) = {
      cc.getAttributes.find(_.getName == name) match {
        case Some(a) if classTag[T].runtimeClass.isInstance(a) => a.asInstanceOf[T]
        case Some(a) => sys.error(s"Expected [${classTag[T].runtimeClass}] got [${a.getClass}] in attribute [$name]")
        case None => sys.error(s"Attribute [$name] not found")
      }
    }
    def stringValue(name: String) = attr[StringAttribute](name).getValues.head
    def image(name: String): Option[ImageAttribute] = {
      for {
        attr <- cc.getAttributes.find(_.getName == name)
        if attr.isInstanceOf[ImageAttribute]
      } yield attr.asInstanceOf[ImageAttribute]
    }
    def link(name: String): LinkContainer = {
      attr[LinkAttribute](name).getLinkContainers.head
    }
  }

  implicit class RichAliasAttribute(alias: AliasAttribute) {
    def mainValue(lang: String): String = alias.getNames.get(lang)
    def allValues(lang: String): Seq[String] = {
      val aliases = alias.getAliases.getOrElse(lang, Collections.emptyList())
      val mainName = Option(alias.getNames.get(lang))
      (mainName ++: aliases).distinct
    }
  }
}

object VerbaDSL extends VerbaDSL