package ru.yandex.tours.extdataloader.verba

import java.io.{ByteArrayInputStream, InputStream}
import java.util.zip.GZIPInputStream

import ru.yandex.extdata.loader.loaders.{SimpleDataLoader, ThreadedHttpClient}
import ru.yandex.tours.util.IO
import ru.yandex.verba2.parse.SaxVerbaParser

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 27.04.15
 */
class VerbaLoader extends SimpleDataLoader[VerbaDataLoadSpec] {

  private var httpLoader: ThreadedHttpClient = _
  private val parser = new SaxVerbaParser

  def setHttpLoader(httpLoader: ThreadedHttpClient): Unit = {
    this.httpLoader = httpLoader
  }

  override def loadData(params: VerbaDataLoadSpec): InputStream = {
    IO.using(new GZIPInputStream(httpLoader.download(params.exportFileUrl))) { is =>
      val service = parser.parseXml(is)
      new ByteArrayInputStream(params.converter(service))
    }
  }
}
