package ru.yandex.tours.extdataloader.verba.parsers

import java.io.PrintWriter

import org.apache.commons.codec.binary.Base64
import org.apache.commons.io.output.ByteArrayOutputStream
import ru.yandex.tours.avatars.AvatarClient
import ru.yandex.tours.extdataloader.verba.Verba
import ru.yandex.tours.extdataloader.verba.VerbaDSL._
import ru.yandex.tours.model.image.ImageProviders
import ru.yandex.tours.util.IO
import ru.yandex.tours.util.parsing.Tabbed

import scala.collection.JavaConverters._
import scala.concurrent.Await
import scala.concurrent.duration._

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 26.08.15
 */
class HotelsVideoBuilder(verba: Verba, avatarClient: AvatarClient) {

  def buildAndSerialize(): Array[Byte] = {
    val dictionary = verba.dictionary("hotel_videos")
    val os = new ByteArrayOutputStream()
    IO.using(new PrintWriter(os)) { writer =>
      for (term <- dictionary.getTerms.asScala) {
        val hotelId = term.intValue("hotel_id")
        val preview = term.stringValue("preview")
        val video = term.stringValue("video")

        val image = Await.result(avatarClient.put(preview, ImageProviders.lih), 30.seconds)

        writer.println(Tabbed(
          hotelId,
          Base64.encodeBase64String(image.toProto.toByteArray),
          video
        ))
      }
    }

    os.toByteArray
  }
}
