package ru.yandex.tours.extdataloader.verba.parsers

import java.io.PrintWriter

import ru.yandex.tours.extdataloader.verba.Verba
import ru.yandex.tours.util.parsing.AtSKV
import ru.yandex.verba2.model.Dictionary

import scala.collection.JavaConversions._

class OnlineAgenciesParser(verba: Verba, dictionaryCode: String) extends VerbaDataParser(verba, dictionaryCode) {
  override protected def convert(dictionary: Dictionary, writer: PrintWriter): Unit = {
    for (term <- dictionary.getTerms) {
      val id = term.stringValue("id")
      val name = term.stringValue("name")
      val billingId = term.stringValue("billing_id")
      val secretKey = term.stringValue("secret_key")
      val actionUrl = term.stringValue("action_url")
      val hotelUrl = term.stringValue("hotel_url")
      val regionsUrl = term.stringValue("regions_url")
      val operatorUrl = term.stringValue("operator_url")
      val authToken = term.stringValue("auth_token")
      val headers = term.complexValue("http_headers").map(container => {
        container.stringValue("key") -> container.stringValue("value")
      })
      val res = Seq(id, name, billingId, secretKey, actionUrl, hotelUrl, regionsUrl, operatorUrl, AtSKV(headers), authToken)
      writer.println(res.mkString("\t"))
    }
  }
}
