package ru.yandex.tours.extdataloader.verba.parsers

import java.io.PrintWriter

import org.apache.commons.io.output.ByteArrayOutputStream
import ru.yandex.tours.extdataloader.verba.Verba
import ru.yandex.tours.model.BaseModel.Pansion
import ru.yandex.tours.util.IO
import ru.yandex.tours.util.parsing.Tabbed
import ru.yandex.verba2.model.attribute.AliasAttribute
import ru.yandex.tours.extdataloader.verba.VerbaDSL._

import scala.collection.JavaConversions._

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 13.05.15
 */
class PansionAliasesBuilder(verba: Verba) {
  private val dictionaryCode = "pansions"

  def parseAliases: Map[Pansion, Seq[String]] = {
    val dictionary = verba.dictionary(dictionaryCode)
    for {
      term <- dictionary.getTerms
    } yield {
      val code = term.stringValue("code")
      val aliases = term.attr[AliasAttribute]("values").allValues("ru")
      Pansion.valueOf(code) -> aliases
    }
  }.toMap

  def buildAndSerialize(): Array[Byte] = {
    val out = new ByteArrayOutputStream()
    IO.using(new PrintWriter(out)) { writer =>
      for {
        (pansion, aliases) <- parseAliases
        alias <- aliases
      } {
        writer.println(Tabbed(pansion.name(), alias))
      }
    }
    out.toByteArray
  }

}
