package ru.yandex.tours.extdataloader.verba.parsers

import java.io.PrintWriter

import ru.yandex.tours.extdataloader.verba.Verba
import ru.yandex.verba2.model.Dictionary
import scala.collection.JavaConversions._

class PartnerStatisticParser(verba: Verba, dictionaryCode: String) extends VerbaDataParser(verba, dictionaryCode) {
  override protected def convert(dictionary: Dictionary, writer: PrintWriter): Unit = {
    for (term <- dictionary.getTerms) {
      val parts = Seq(
        term.stringValue("id"),
        term.doubleValue("conversion"),
        term.longOptValue("calculated_cpc").map(_.toString).getOrElse("")
      )
      writer.println(parts.mkString("\t"))
    }
  }
}