package ru.yandex.tours.extdataloader.verba.parsers

import java.io.PrintWriter

import ru.yandex.tours.extdataloader.verba.{Verba, VerbaDSL}
import ru.yandex.tours.util.IO
import ru.yandex.verba2.model._

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 27.04.15
 */
abstract class VerbaDataParser(verba: Verba, dictionaryCode: String) extends VerbaDSL {

  protected def convert(dictionary: Dictionary, writer: PrintWriter): Unit

  def build(): Array[Byte] = {
    val dictionary = verba.dictionary(dictionaryCode)
    IO.printBytes { writer =>
      convert(dictionary, writer)
    }
  }
}
