package ru.yandex.tours.extdataloader.verba.parsers

import java.io.PrintWriter

import ru.yandex.tours.extdataloader.verba.Verba
import ru.yandex.verba2.model.Dictionary
import ru.yandex.verba2.model.attribute.AliasAttribute

import scala.collection.JavaConversions._

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 27.04.15
 */
class WizardDatesParser(verba: Verba, dictionaryCode: String) extends VerbaDataParser(verba, dictionaryCode) {
  override protected def convert(dictionary: Dictionary, writer: PrintWriter): Unit = {
    for (term <- dictionary.getTerms) {
      writer.println("\n#" + term.getPath)
      val from = term.stringValue("from")
      val until = term.stringValue("until")
      val phrases = term.attr[AliasAttribute]("phrase").allValues("ru")
      for (phrase <- phrases) {
        writer.println(s"$from\t$until\t$phrase")
      }
    }
  }
}
