package ru.yandex.tours.extdataloader.verba.parsers

import ru.yandex.tours.extdataloader.verba.{Verba, VerbaDSL}
import ru.yandex.verba2.model.attribute.AliasAttribute

import scala.collection.JavaConverters._
import scala.collection.mutable

/**
  * Created by asoboll on 04.10.17.
  */
class WizardHotelAliasesReader(verba: Verba) extends VerbaDSL {

  private val dictionaryCode = "wizard.hotels"
  private val langs = Seq("ru", "en")

  def loadAliases: collection.Map[Int, Seq[String]] = {
    val dictionary = verba.dictionary(dictionaryCode)
    val aliases = new mutable.HashMap[Int, Seq[String]]()
    for (term ← dictionary.getTerms.asScala) {
      val hotelId = term.intValue("hotel_id")
      val phrases = langs.flatMap(lang => term.attr[AliasAttribute]("phrase").allValues(lang))
      for (phrase ← phrases) {
        aliases += hotelId → phrases
      }
    }
    aliases
  }

}
