package ru.yandex.tours.extdataloader.verba.parsers

import java.io.PrintWriter

import ru.yandex.tours.extdataloader.verba.Verba
import ru.yandex.verba2.model.Dictionary
import ru.yandex.verba2.model.attribute.AliasAttribute

import scala.collection.JavaConversions._

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 29.04.15
 */
class WizardOperatorsParser(verba: Verba, dictionaryCode: String) extends VerbaDataParser(verba, dictionaryCode) {
  override protected def convert(dictionary: Dictionary, writer: PrintWriter): Unit = {
    for (term <- dictionary.getTerms) {
      writer.println("\n#" + term.getPath)
      val id = term.intValue("id")
      val names = term.attr[AliasAttribute]("name").allValues("ru")
      for (name <- names) {
        writer.println(id + "\t" + name)
      }
    }
  }
}
