package ru.yandex.tours.indexer.agencies

import java.io.InputStream

import org.apache.commons.io.IOUtils
import ru.yandex.tours.util.parsing.{LongValue, Tabbed}

import scala.util.Try

object AgencyShowsParser {
  def parse(is: InputStream): Map[Long, Int] = {
    val id2shows = scala.io.Source.fromInputStream(is).getLines().map {
      case Tabbed(LongValue(id),	link,	rubrics,	nameRu,	addressRu,	phones,	workingTime,	shows) =>
        Try(shows.trim.replaceAll("\\D", "").toInt).toOption.map(t => id -> t)
    }.flatten.toMap
    IOUtils.closeQuietly(is)
    id2shows
  }
}
