package ru.yandex.tours.indexer.billing

import java.io.InputStream

import ru.yandex.extdata.common.service.ExtDataService
import ru.yandex.extdata.loader.engine.DataPersistenceManager
import ru.yandex.tours.agencies.AgencyPartneringIndex
import ru.yandex.tours.extdata.DataTypes
import ru.yandex.tours.indexer.task.TaskWeight

import scala.concurrent.ExecutionContext
import scala.concurrent.duration.FiniteDuration

class AgencyPartneringReceiver(extDataService: ExtDataService,
                                dataPersistenceManager: DataPersistenceManager,
                                updateTime: FiniteDuration)
                              (implicit ex: ExecutionContext)
  extends AbstractInfoReceiver[Set[Int]](extDataService, dataPersistenceManager, updateTime, DataTypes.offlineAgencyPartnering)
    with TaskWeight.Light {

  override protected def parseIs(is: InputStream): Iterable[(Long, Set[Int])] = AgencyPartneringIndex.parseMapping(is)

  override protected def dump(info: Iterable[(Long, Set[Int])]): Array[Byte] = {
    info.map {
      case (id, partners) => (Seq(id) ++ partners.toSeq).mkString("\t")
    }.mkString("\n").getBytes("UTF-8")
  }
}