package ru.yandex.tours.indexer.billing

import java.io._
import java.nio.ByteBuffer

import ru.yandex.extdata.common.meta.DataType
import ru.yandex.extdata.common.service.ExtDataService
import ru.yandex.extdata.loader.engine.DataPersistenceManager
import ru.yandex.tours.billing.BillingOffers
import ru.yandex.tours.indexer.task.TaskWeight
import ru.yandex.vertis.billing.Model.OfferBilling

import scala.concurrent.ExecutionContext
import scala.concurrent.duration.FiniteDuration

class BillingReceiver(extDataService: ExtDataService,
                      dataPersistenceManager: DataPersistenceManager,
                      updateTime: FiniteDuration,
                      dataType: DataType)
                     (implicit ex: ExecutionContext)
  extends AbstractInfoReceiver[OfferBilling](extDataService, dataPersistenceManager, updateTime, dataType)
    with TaskWeight.Light {

  override protected def parseIs(is: InputStream): Iterable[(Long, OfferBilling)] = {
    val res = BillingOffers.parseIdAndOffers(is)
    res.foreach {
      case (id, offer) => log.info(
        s"Parsed offer id = $id," +
        s" campaign name = ${offer.getKnownCampaign.getCampaign.getName}," +
        s" is active = ${offer.getKnownCampaign.getIsActive}," +
        s" campaign id = ${offer.getKnownCampaign.getCampaign.getId}," +
        s" owner agency id = ${offer.getKnownCampaign.getCampaign.getOwner.getId.getAgencyId}, " +
        s" owner client id = ${offer.getKnownCampaign.getCampaign.getOwner.getId.getClientId}"
      )
    }
    res
  }


  override def receive(id: Long, info: OfferBilling): Unit = {
    val offer = info
    log.info(s"Received offer id = $id, campaign name = ${offer.getKnownCampaign.getCampaign.getName}," +
      s" is active = ${offer.getKnownCampaign.getIsActive}," +
      s" campaign id = ${offer.getKnownCampaign.getCampaign.getId}," +
      s" owner agency id = ${offer.getKnownCampaign.getCampaign.getOwner.getId.getAgencyId}, " +
      s" owner client id = ${offer.getKnownCampaign.getCampaign.getOwner.getId.getClientId}"
    )
    super.receive(id, info)
  }

  override protected def dump(info: Iterable[(Long, OfferBilling)]): Array[Byte] = {
    val baos = new ByteArrayOutputStream()
    info.foreach({ case (id, offer) =>
      log.info(s"Dumping offer id = $id, campaign name = ${offer.getKnownCampaign.getCampaign.getName}," +
        s" is active = ${offer.getKnownCampaign.getIsActive}," +
        s" campaign id = ${offer.getKnownCampaign.getCampaign.getId}," +
        s" owner agency id = ${offer.getKnownCampaign.getCampaign.getOwner.getId.getAgencyId}, " +
        s" owner client id = ${offer.getKnownCampaign.getCampaign.getOwner.getId.getClientId}"
      )
      val byteBuffer = ByteBuffer.allocate(8).putLong(id)
      baos.write(byteBuffer.array())
      offer.writeDelimitedTo(baos)
    })
    baos.toByteArray
  }
}
