package ru.yandex.tours.indexer.booking

import java.io.PrintWriter

import ru.yandex.tours.indexer.hotels.parsers.booking.{BookingHotel2RegionRetriever, S3Hotel2RegionRetriever}
import ru.yandex.tours.indexer.task.{AsyncUpdatable, TaskWeight}
import ru.yandex.tours.util.IO
import ru.yandex.tours.util.s3.S3Client
import ru.yandex.tours.util.parsing.Tabbed
import spray.http.StatusCodes

import scala.concurrent.{ExecutionContext, Future}
import scala.concurrent.duration.FiniteDuration

class BookingHotelRegionsIndexer(regionRetriever: BookingHotel2RegionRetriever,
                                 s3Client: S3Client,
                                 updateTime: FiniteDuration)(implicit ec: ExecutionContext)
  extends AsyncUpdatable(updateTime, "booking_regions") with TaskWeight.Heavy {
  override protected def update: Future[_] = {
    for {
      map <- regionRetriever.retrieve
      file = dumpToFile(map)
      (sc, entity) <- s3Client.uploadFile(S3Hotel2RegionRetriever.resourceName, file)
    } yield {
      IO.deleteFile(file)
      if (sc != StatusCodes.OK) sys.error(s"Can not upload booking regions to S3! Sc: $sc, entity: $entity")
    }
  }

  private def dumpToFile(map: Map[String, String]) = {
    IO.usingTmp("booking-hotel-region-indexer") { os =>
      IO.using(new PrintWriter(os)) { pw =>
        for {
          (key, value) <- map
        } pw.println(Tabbed(key, value))
      }
    }
  }
}
