package ru.yandex.tours.indexer.clusterization

import java.util.concurrent.atomic.{AtomicInteger, AtomicLong, LongAdder}

import ru.yandex.tours.util.Logging

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 25.05.16
 */
class ClusteringMetrics extends Logging {
  private val started = System.nanoTime()
  private val processed = new LongAdder()
  private val processedPairs = new LongAdder()
  private val links = new LongAdder()
  private val published = new LongAdder()
  private val notPublished = new LongAdder()

  def addHotels(published: Int, notPublished: Int): Unit = {
    this.published.add(published)
    this.notPublished.add(notPublished)
    this.processed.add(published + notPublished)

  }

  def addLinks(count: Int): Unit = {
    links.add(count)
  }

  def addPair(): Unit = {
    processedPairs.increment()
  }

  def doLogging(): Unit = {
    val elapsed = System.nanoTime() - started
    val processed = this.processed.sum()
    val processedPairs = this.processedPairs.sum
    log.info(s"Clusterization done for $processed hotels. " +
      s"Published: ${this.published}, not published: ${this.notPublished}, links: $links")
    log.info(s"Processed $processedPairs pairs in ${elapsed / 1e9.toLong} seconds")
    log.info(f"Average processing time = ${elapsed.toDouble / processedPairs / 1e6}%.2f ms. per pair, " +
      f"${elapsed.toDouble / processed / 1e6}%.2f ms. per hotel")
  }
}
