package ru.yandex.tours.indexer.clusterization

import ru.yandex.tours.clustering.Clustering.LinkWithConfidence
import ru.yandex.tours.model.hotels.HotelsHolder.PartnerHotel

import scala.concurrent.Future

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 06.05.16
 */
trait Clusterizer {
  def getMergeResult(slaves: Iterator[PartnerHotel]): Future[Seq[LinkWithConfidence]]
}

trait ClusterizerFactory {
  def apply(master: Grid[PartnerHotel], slave: Grid[PartnerHotel]): Clusterizer
}