package ru.yandex.tours.indexer.clusterization

import akka.actor.ActorSystem
import ru.yandex.tours.db.DBWrapper
import ru.yandex.tours.db.dao.HotelsDao
import ru.yandex.tours.hotels.clustering.ClusteringModel
import ru.yandex.tours.model.hotels.Partners
import ru.yandex.tours.model.hotels.Partners.Partner

import scala.concurrent.ExecutionContext

/**
  * Created by asoboll on 09.03.17.
  */
class HotelsCombinedClusterizer(dbWrapper: DBWrapper,
                                hotelsDao: HotelsDao,
                                clusteringModel: ClusteringModel)
                               (implicit akka: ActorSystem, ec: ExecutionContext)
  extends MappingValidationClusterizer("cluster_hotelscombined", dbWrapper, hotelsDao, clusteringModel) {

  override protected val partnerFilter: Option[Partner] = Some(Partners.hotelsCombined)

  override protected val mappingDescription: Seq[(Partner, String)] = Seq(
    Partners.booking -> "BookingID",
    Partners.oktogo -> "OktogoID"
  )

}
