package ru.yandex.tours.indexer.clusterization

import java.io.ByteArrayInputStream

import akka.actor.ActorSystem
import ru.yandex.tours.clustering.Clustering.LinkWithConfidence
import ru.yandex.tours.hotels.clustering.ClusteringModel
import ru.yandex.tours.model.hotels.HotelsHolder.PartnerHotel
import ru.yandex.tours.util.naming.TfIdfModel
import ru.yandex.vertis.matrixnet.MnFormulaReader

import scala.concurrent.{ExecutionContext, Future}

class MemoryClusterizer(tfIdf: Array[Byte], rawFormula: Array[Byte])(implicit ec: ExecutionContext, as: ActorSystem) {
  def clusterize(hotels: Iterator[PartnerHotel]): Future[Seq[LinkWithConfidence]] = {
    val inMemoryHotels = hotels.toList
    val tfIdfModel = TfIdfModel.parse(new ByteArrayInputStream(tfIdf))
    val formula = new MnFormulaReader().load(new ByteArrayInputStream(rawFormula))
    val model = new ClusteringModel(tfIdfModel, formula)
    val matrixnetClusterizer = new MatrixnetClusterizer(
      new GridInMemory[PartnerHotel](inMemoryHotels, _.getRawHotel.getPoint),
      new GridInMemory[PartnerHotel](inMemoryHotels, _.getRawHotel.getPoint),
      4,
      model
    )
    matrixnetClusterizer.getMergeResult(inMemoryHotels.iterator)
  }
}
