package ru.yandex.tours.indexer.clusterization

import akka.actor.ActorSystem
import ru.yandex.tours.db.DBWrapper
import ru.yandex.tours.db.dao.HotelsDao
import ru.yandex.tours.hotels.clustering.ClusteringModel
import ru.yandex.tours.model.hotels.Partners
import ru.yandex.tours.model.hotels.Partners.Partner

import scala.concurrent.ExecutionContext

/**
  * Created by alexcrush on 15.11.17.
  */
class OstrovokV3Clusterizer(dbWrapper: DBWrapper,
                            hotelsDao: HotelsDao,
                            clusteringModel: ClusteringModel)
                           (implicit akka: ActorSystem, ec: ExecutionContext)
  extends MappingValidationClusterizer("cluster_ostrovokv3", dbWrapper, hotelsDao, clusteringModel) {

  override protected val partnerFilter: Option[Partner] = Some(Partners.ostrovokv3)

  override protected val mappingDescription: Seq[(Partner, String)] = Seq(
    Partners.booking -> "booking"
  )

}
