package ru.yandex.tours.indexer.clusterization.similarity

import ru.yandex.tours.model.hotels.HotelsHolder.PartnerHotel

case class CombinedSimilarity(hotelSimilarity: HotelSimilarity*) extends HotelSimilarity {
  /**
   *
   * @param a - first hotel
   * @param b - second hotel
   * @return - returns 0, if all parent similarities are 0
   */
  override def similarity(a: PartnerHotel, b: PartnerHotel): Double =
    hotelSimilarity.find(_.similarity(a, b) > 1e-8) match {
      case Some(_) => 1
      case None => 0
    }

  override def name: String = "combined_" + hotelSimilarity.map(_.name).mkString("\t")
}
