package ru.yandex.tours.indexer.clusterization.similarity

import ru.yandex.tours.hotels.HotelsUtil
import ru.yandex.tours.model.hotels.HotelsHolder.PartnerHotel

case class DistanceThresholdSimilarity(thresholdInKm: Double) extends HotelSimilarity {
  /**
   *
   * @param a - first hotel
   * @param b - second hotel
   * @return - 0 if distance is bellow threshold, 1 otherwise
   */
  override def similarity(a: PartnerHotel, b: PartnerHotel): Double = {
    if (a.getRawHotel.hasPoint && b.getRawHotel.hasPoint) {
      if (HotelsUtil.distance(a.getRawHotel.getPoint, b.getRawHotel.getPoint) <= thresholdInKm) 0 else 1
    } else {
      -1
    }
  }

  override def name: String = s"distance_threshold_$thresholdInKm"
}