package ru.yandex.tours.indexer.clusterization.similarity

import ru.yandex.tours.model.hotels.HotelsHolder.PartnerHotel
import ru.yandex.tours.util.google.GooglePlaceClient

import scala.concurrent.duration._
import scala.concurrent.{Await, ExecutionContext}

class GoogleMapSimilarity(googleClient: GooglePlaceClient)(implicit ec: ExecutionContext) extends HotelSimilarity {
  /**
   *
   * @param a - first hotel
   * @param b - second hotel
   * @return - value between 0 and 1. Values closer to 0 means more similarity
   */
  override def similarity(a: PartnerHotel, b: PartnerHotel): Double = {
    val result = for {
      aGoogle <- googleClient.searchIds(a)
      bGoogle <- googleClient.searchIds(b)
    } yield {
        if (aGoogle.headOption == bGoogle.headOption && aGoogle.nonEmpty) {
          0.0
        } else {
          1.0
        }
//        if (aGoogle.isEmpty || bGoogle.isEmpty) {
//          1
//        } else {
//          ComparingUtil.jacardIndex(aGoogle.toSet, bGoogle.toSet)
//        }
      }
    Await.result(result, 30.seconds)
  }

  override def name: String = "google_map"
}
