package ru.yandex.tours.indexer.export

import java.io.PrintWriter

import ru.yandex.tours.hotels.HotelsIndex
import ru.yandex.tours.indexer.task.TaskWeight
import ru.yandex.tours.model.hotels.Partners
import ru.yandex.tours.model.search.SearchType
import ru.yandex.tours.model.utm.UtmMark
import ru.yandex.tours.serialize.UrlBuilder
import ru.yandex.tours.util.IO
import ru.yandex.tours.util.s3.S3Client
import ru.yandex.tours.util.parsing.Tabbed

import scala.concurrent.duration.FiniteDuration
import scala.concurrent.{ExecutionContext, Future}

class BackaMatchingExporter(hotelsIndex: HotelsIndex,
                            s3Client: S3Client,
                            urlBuilder: UrlBuilder,
                            updateTime: FiniteDuration)
                           (implicit ec: ExecutionContext)
  extends Exporter("backa_matching", "backa_matching", s3Client, updateTime) with TaskWeight.Medium {

  protected def generateExport() = Future {
    IO.usingTmp("backa-matching-exporter") { os =>
      IO.using(new PrintWriter(os)) { pw =>
        for {
          hotel <- hotelsIndex.hotels
          pi <- hotel.partnerIds
          if pi.partner == Partners.backa
        } {
          val context = if (hotel.roomsSearchAvailable) SearchType.ROOMS else SearchType.TOURS
          val url = urlBuilder.forHotelDefault(hotel.id, UtmMark(source = Some("yandex-maps")), context)
          pw.println(Tabbed(pi.id, url))
        }
      }
    }
  }
}
