package ru.yandex.tours.indexer.google

import akka.actor.ActorRefFactory
import ru.yandex.tours.db.DBWrapper
import ru.yandex.tours.db.dao.HotelsDao
import ru.yandex.tours.indexer.task.{AsyncUpdatable, TaskWeight}
import ru.yandex.tours.util.google.{HttpGooglePlaceClient, InstrumentedHttpGooglePlaceClient}
import ru.yandex.tours.util.http.AsyncHttpClient

import scala.concurrent.{ExecutionContext, Future}
import scala.concurrent.duration.FiniteDuration

class GooglePlacesIndexer(db: DBWrapper, hotelsDao: HotelsDao, httpClient: AsyncHttpClient, updateTime: FiniteDuration)
                         (implicit ec: ExecutionContext, actorRefFactory: ActorRefFactory)
  extends AsyncUpdatable(updateTime, "google_places") with TaskWeight.Heavy {

  override protected def update: Future[_] = {
    val googleClient = new HttpGooglePlaceClient(httpClient)
    val instrumented = new InstrumentedHttpGooglePlaceClient(googleClient)
    val downloader = new GooglePlacesDownloader(db, hotelsDao, instrumented)
    downloader.run()
  }
}
