package ru.yandex.tours.indexer.hotelcounts

import java.io.ByteArrayInputStream

import ru.yandex.extdata.loader.engine.DataPersistenceManager
import ru.yandex.tours.geo.partners.PartnerRegionHotelCounts
import ru.yandex.tours.hotels.HotelsIndex
import ru.yandex.tours.indexer.task.{AsyncUpdatable, TaskWeight}

import scala.concurrent.duration.FiniteDuration
import scala.concurrent.{ExecutionContext, Future}

/**
  * Created by asoboll on 28.02.16.
  */
class PartnerHotelCountsIndexer(dataPersistenceManager: DataPersistenceManager,
                                hotelsIndex: HotelsIndex,
                                duration: FiniteDuration)
                               (implicit ex: ExecutionContext)
  extends AsyncUpdatable(duration, "hotel_counts_indexer") with TaskWeight.Medium {

  override protected def update: Future[_] = Future {
    val region2count = PartnerRegionHotelCounts.newCountsMap

    for {
      hotel <- hotelsIndex.hotels
      partnerInfo <- hotel.partnerIds
    } PartnerRegionHotelCounts.countPartnerInfo(region2count)(partnerInfo)

    val byteArray = new PartnerRegionHotelCounts(region2count).toByteArray
    dataPersistenceManager.checkAndStore(PartnerRegionHotelCounts.dataType, new ByteArrayInputStream(byteArray))
  }
}
