package ru.yandex.tours.indexer.hotels

import java.io.File

import akka.actor.ActorRefFactory
import akka.stream.ActorMaterializer
import akka.stream.scaladsl.Source
import ru.yandex.tours.model.hotels.HotelsHolder.PartnerHotel
import ru.yandex.tours.model.hotels.Partners.Partner
import ru.yandex.tours.util.collections.RafBasedMap
import ru.yandex.tours.util.{IO, ProtoIO}

import scala.concurrent.{Future, ExecutionContext}

class AddInfoEnricher(slopeDistanceEnricher: SlopeDistanceEnricher)
                     (implicit actorRefFactory: ActorRefFactory, ec: ExecutionContext) {

  private val parallelism = 4
  private implicit val actorMaterializer = ActorMaterializer()

  def enrich(file: File, oldHotels: RafBasedMap[Int, PartnerHotel], partner: Partner): Future[File] = {
    IO.usingAsyncTmp("add_info_enricher") { os =>
      Source.fromIterator(() => ProtoIO.loadFromFile(file, PartnerHotel.PARSER))
        .map(hotel => hotel -> oldHotels.get(hotel.getId))
        .mapAsync(parallelism)((process _).tupled)
        .runForeach(_.writeDelimitedTo(os))
    }
  }

  private def process(hotel: PartnerHotel, oldHotel: Option[PartnerHotel]): Future[PartnerHotel] = Future {
    val builder = hotel.toBuilder
    slopeDistanceEnricher.enrich(builder)
    setHotelType(builder, oldHotel)
    builder.build()
  }
  
  private def setHotelType(builder: PartnerHotel.Builder, optOld: Option[PartnerHotel]) = {
    if (builder.getRawHotel.hasType) {
      builder.setType(builder.getRawHotel.getType)
    } else if (optOld.isDefined) {
      val old = optOld.get
      if (old.hasType) {
        builder.setType(old.getType)
      }
    }
  }
}
