package ru.yandex.tours.indexer.hotels

import java.io.{File, PrintWriter}

import ru.yandex.tours.filter.{FilterHolder, Filters}
import ru.yandex.tours.geo.base.region.Tree
import ru.yandex.tours.model.hotels.Hotel
import ru.yandex.tours.util.IO
import ru.yandex.tours.util.collections.Bag
import ru.yandex.tours.util.parsing.Tabbed

class HiddenFiltersCalculator(tree: Tree) {
  def process(hotels: TraversableOnce[Hotel]): File = {
    val hotelCountByRegion = new Bag[Int]()
    val emptyFilterCount = new Bag[(Int, FilterHolder[_])]()
    for {
      hotel <- hotels
      region <- tree.pathToRoot(hotel.geoId)
    } {
      hotelCountByRegion += region.id
      for {
        filterHolder <- Filters.hotelHolders
        if filterHolder.getValues(hotel).isEmpty
      } {
        emptyFilterCount += ((region.id, filterHolder))
      }
    }
    IO.usingTmp("hidden_filters") { os =>
      IO.using(new PrintWriter(os)) { pw =>
        emptyFilterCount.entriesDesc.foreach {
          case ((regionId, holder), count) =>
            // If less than 10% of hotels has values in filter, than this filter is hidden
            if (1.0 * count / hotelCountByRegion.getCount(regionId) > 0.9) pw.println(Tabbed(regionId, holder.name))
        }
      }
    }
  }
}
