package ru.yandex.tours.indexer.hotels

import java.io.FileInputStream

import ru.yandex.extdata.loader.engine.DataPersistenceManager
import ru.yandex.tours.extdata.DataTypes
import ru.yandex.tours.hotels.HotelsIndex
import ru.yandex.tours.indexer.task.{AsyncUpdatable, TaskWeight}
import ru.yandex.tours.util.IO

import scala.concurrent.duration.FiniteDuration
import scala.concurrent.{ExecutionContext, Future}

class HiddenFiltersIndexer(calculator: HiddenFiltersCalculator,
                           dataPersistenceManager: DataPersistenceManager,
                           hotelsIndex: HotelsIndex,
                           updateTime: FiniteDuration)
                          (implicit ec: ExecutionContext)
  extends AsyncUpdatable(updateTime, "hidden_filters") with TaskWeight.Medium {

  override protected def update: Future[_] = Future {
    val file = calculator.process(hotelsIndex.hotels)
    try {
      IO.using(new FileInputStream(file)) { is =>
        dataPersistenceManager.checkAndStore(DataTypes.hiddenFilters, is)
      }
    } finally IO.deleteFile(file)
  }
}
