package ru.yandex.tours.indexer.hotels

import java.io.FileInputStream

import ru.yandex.extdata.loader.engine.DataPersistenceManager
import ru.yandex.tours.extdata.DataTypes
import ru.yandex.tours.geo.base.region.Tree
import ru.yandex.tours.hotels.{HotelsExport, HotelsIndex}
import ru.yandex.tours.indexer.task.{AsyncUpdatable, TaskWeight}

import scala.concurrent.duration.FiniteDuration
import scala.concurrent.{ExecutionContext, Future}

class HotelsExporter(hotelsIndex: HotelsIndex,
                     tree: Tree,
                     persistenceManager: DataPersistenceManager,
                     period: FiniteDuration)
                    (implicit val ec: ExecutionContext)
  extends AsyncUpdatable(period, DataTypes.hotelsExport.getName) with TaskWeight.Medium {
  
  override protected def update = Future {
    val result = HotelsExport.prepare(hotelsIndex.hotels, tree)
    val is = new FileInputStream(result)
    try {
      persistenceManager.checkAndStore(DataTypes.hotelsExport, is)
    } finally {
      is.close()
      result.delete()
    }
  }
}
