package ru.yandex.tours.indexer.hotels

import ru.yandex.tours.indexer.task.{AsyncUpdatable, TaskWeight}
import ru.yandex.tours.model.hotels.Partners.Partner
import ru.yandex.tours.util.IO

import scala.concurrent.{ExecutionContext, Future}
import scala.concurrent.duration.FiniteDuration
import scala.util.{Failure, Success}

class PartnerHotelIndexRunner(indexer: PartnerHotelsIndexer, partner: Partner, updateTime: FiniteDuration)
                             (implicit ec: ExecutionContext)
  extends AsyncUpdatable(updateTime, s"${partner}_hotels") with TaskWeight.Heavy {

  override protected def update: Future[_] = indexer.index.andThen {
    case Success(file) =>
      log.info(s"Successfully indexed $partner hotels")
      IO.deleteFile(file)
    case Failure(e) =>
      log.warn(s"Can not update $partner hotels", e)
  }
}
