package ru.yandex.tours.indexer.hotels

import java.io.{File, FileInputStream, InputStream}

import ru.yandex.tours.model.hotels.Partners.Partner
import ru.yandex.tours.util.IO

import scala.concurrent.Future

trait PartnerHotelParser {

  /**
   * @param is - input stream to parse
   * @return file, which contains delimited [[ru.yandex.tours.model.hotels.HotelsHolder.RawPartnerHotel]]
   */
  def parse(is: InputStream): Future[File]

  def parse(file: File): Future[File] = IO.usingAsync(new FileInputStream(file))(parse)

  def partner: Partner
}
